% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{rKernelCov}
\alias{rKernelCov}
\title{Realized Covariance: Kernel}
\usage{
rKernelCov(
  rData,
  cor = FALSE,
  alignBy = "seconds",
  alignPeriod = 1,
  makeReturns = FALSE,
  kernelType = "rectangular",
  kernelParam = 1,
  kernelDOFadj = TRUE
)
}
\arguments{
\item{rData}{a \eqn{(M x N)} matrix/zoo/xts object containing the \eqn{N}
return series over period \eqn{t}, with \eqn{M} observations during \eqn{t}.}

\item{cor}{boolean, in case it is TRUE, the correlation is returned. FALSE by default.}

\item{alignBy}{Align the tick data to seconds|minutes|hours}

\item{alignPeriod}{Align the tick data to this many [seconds|minutes|hours]}

\item{makeReturns}{Convert to Returns}

\item{kernelType}{Kernel name (or number)}

\item{kernelParam}{Kernel parameter (usually lags)}

\item{kernelDOFadj}{Kernel Degree of freedom adjustment}
}
\value{
Kernel estimate of realized covariance.
}
\description{
Realized covariance calculation using a kernel estimator.
}
\details{
The different types of kernels can be found using \code{\link{listAvailableKernels}}.
}
\examples{
# Univariate:
rvKernel <- rKernelCov(rData = sampleTData$PRICE, alignBy = "minutes",
                       alignPeriod = 5, makeReturns = TRUE)
rvKernel

# Multivariate:
rcKernel <- rKernelCov(rData = cbind(lltc, sbux, fill = 0), alignBy = "minutes",
                       alignPeriod = 5, makeReturns = FALSE)
rcKernel
}
\references{
Ole E. Barndorff-Nielsen, Peter Reinhard Hansen, Asger Lunde, and Neil Shephard (2008). Designing Realized Kernels to Measure the ex post Variation of Equity Prices in the Presence of Noise. \emph{Econometrica}, 76, pp. 1481-1536.

B. Zhou. High-frequency data and volatility in foreign-exchange rates. \emph{Journal of Business & Economic Statistics}, 14:45-52, 1996.

P. Hansen and A. Lunde. Realized variance and market microstructure noise. \emph{Journal of Business and Economic Statistics}, 24:127-218, 2006.
}
\author{
Scott Payseur and Onno Kleen
}
\keyword{volatility}
