% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{rSemiCov}
\alias{rSemiCov}
\title{Realized Semicovariance}
\usage{
rSemiCov(
  rData,
  cor = FALSE,
  alignBy = NULL,
  alignPeriod = NULL,
  makeReturns = FALSE
)
}
\arguments{
\item{rData}{a \eqn{(M x N)} matrix/zoo/xts object containing the \eqn{N}
return series over period \eqn{t}, with \eqn{M} observations during \eqn{t}.
In case of a matrix, no multi-day adjustment is possible.}

\item{cor}{logical, in case it is TRUE, the correlation is returned. FALSE by default.}

\item{alignBy}{a string, align the tick data to "seconds"|"minutes"|"hours".}

\item{alignPeriod}{an integer, align the tick data to this many [seconds|minutes|hours].}

\item{makeReturns}{logical, should be TRUE when rData contains prices instead of returns. FALSE by default.}
}
\value{
In case the data consists of one day a list of four \eqn{N x N} matrices are returned. These matrices are the mixed, positive, negative and concordant
In case the data spans more than one day, the list for each day will be put into another list named according to the date of the estimates.
}
\description{
Function returns the Realized Semicovariances (rSemiCov).
Let \eqn{r_{t,i}} be an intraday \eqn{M x N} return matrix and \eqn{i=1,...,M}
the number of intraday returns. Then, let p = max(r_{t,i},0) and n = min(r_{t,i}).

Then, the realized semicovariance is given by the following three matrices:

\deqn{
 \mbox{pos}_t =\sum_{i=1}^{M}p_{t,i}p'_{t,i}
} 
\deqn{
 \mbox{neg}_t =\sum_{i=1}^{M}n_{t,i}n'_{t,i}
} 
\deqn{
 \mbox{mixed}_t =\sum_{i=1}^{M}(p_{t,i}n'_{t,i} + n_{t,i}p'_{t,i})
}

The mixed covariance matrix will have 0 on the diagonal.
From these three matrices, the realized covariance can be constructed as pos + neg + mixed.
The concordant semicovariance matrix is pos + neg.
The off-diagonals of the concordant matrix is always positive, while for the mixed matrix, it is always negative.
}
\details{
In the case that cor is TRUE, the mixed matrix will be an \eqn{N x N} matrix filled with NA as mapping the mixed covariance matrix into correlation space is impossible due to the 0-diagonal.
}
\examples{
# Realized semi-variance/semi-covariance for prices aligned   
# at 5 minutes.
data(sampleTData)
data(sample5MinPricesJumps)

# Univariate: 
rSV = rSemiCov(rData = sampleTData$PRICE, alignBy = "minutes", 
                   alignPeriod = 5, makeReturns = TRUE)

# Multivariate single day: 
rSC = rSemiCov(rData = sample5MinPricesJumps['2010-01-04'], makeReturns=TRUE)

\dontrun{
# Multivariate multi day:
rSC <- rSemiCov(sample5MinPrices, makeReturns = TRUE) # rSC is a list of lists
# We extract the covariance between stock 1 and stock 2 for all three covariances.
mixed <- do.call(rbind, lapply(rSC, function(x) x[["mixed"]][1,2]))
neg <- do.call(rbind, lapply(rSC, function(x) x[["negative"]][1,2]))
pos <- do.call(rbind, lapply(rSC, function(x) x[["positive"]][1,2]))
covariances <- xts(cbind(mixed, neg, pos), as.Date(rownames(pos)))
colnames(covariances) <- c("mixed", "neg", "pos")
# We make a quick plot of the different covariances
plot(covariances)
addLegend(lty = 1) # Add legend so we can distinguish the series.
}
}
\author{
Emil Sjoerup

Emil Sjoerup
}
\keyword{volatility}
