% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmde_plot_obs_est_inds.R
\name{hmde_plot_obs_est_inds}
\alias{hmde_plot_obs_est_inds}
\title{Plot estimated and observed values over time for a chosen number of individuals based
on posterior estimates. Structured to take in the measurement_data tibble constructed by
the hmde_extract_estimates function.}
\usage{
hmde_plot_obs_est_inds(
  estimate_list = NULL,
  measurement_data = NULL,
  ind_id_vec = NULL,
  n_ind_to_plot = NULL,
  xlab = "Time",
  ylab = "Y(t)",
  title = NULL
)
}
\arguments{
\item{estimate_list}{list output of hmde_extract_estimates}

\item{measurement_data}{tibble with estimated measurements}

\item{ind_id_vec}{vector with list of ind_id values}

\item{n_ind_to_plot}{integer giving number of individuals to plot if not specified}

\item{xlab}{character string for replacement x axis label}

\item{ylab}{character string for replacement y axis label}

\item{title}{character string for replacement plot title}
}
\value{
ggplot object
}
\description{
Plot estimated and observed values over time for a chosen number of individuals based
on posterior estimates. Structured to take in the measurement_data tibble constructed by
the hmde_extract_estimates function.
}
\examples{
# basic usage of hmde_plot_obs_est_inds
hmde_plot_obs_est_inds(estimate_list = Tree_Size_Ests,
                       n_ind_to_plot = 5)

}
