% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleo.R
\name{plot_paleo}
\alias{plot_paleo}
\title{Download and plot essential climate data}
\usage{
plot_paleo(dataset = get_paleo(), print = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_paleo}, defaults to calling \code{get_paleo}}

\item{print}{(boolean) Display Vostok ice core ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with the Vostok chart
}
\description{
Plots the Vostok ice core data retrieved using \code{get_paleo()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_paleo} invisibly returns a ggplot2 object with a pre-defined Vostok ice core chart using data from \code{get_paleo}.
The returned chart stacks carbon dioxide concentration over temperature over 420,000 years.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Fetch Vostok data:
vostok <- get_paleo()
#
# Plot output using package's built-in ggplot2 defaults
plot_paleo(vostok)

# Or just call plot_paleo(), which defaults to get_paleo() dataset
plot_paleo()

p <- plot_paleo(vostok, print = FALSE)
# Modify plot such as: p + patchwork::plot_annotation(title='A Long History of Carbon') }

}
\references{
Barnola, J.-M., D. Raynaud, C. Lorius, and N.I. Barkov. 2003. Historical CO2 record from the Vostok ice core. In Trends: A Compendium of Data on Global Change. Carbon Dioxide Information Analysis Center, Oak Ridge National Laboratory, U.S. Department of Energy, Oak Ridge, Tenn., U.S.A
}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
