% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_temp.R
\name{plot_dailytemp}
\alias{plot_dailytemp}
\title{Download and plot essential climate data}
\usage{
plot_dailytemp(
  dataset = get_dailytemp(),
  print = TRUE,
  anomaly = TRUE,
  current_year = as.numeric(substr(Sys.Date(), 1, 4)),
  title_lab = "Daily Average Air Temperature"
)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_dailytemp}}

\item{print}{(boolean) Display daily temperature ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}

\item{anomaly}{(boolean) Display current anomaly versus historic mean, defaults to TRUE.}

\item{current_year}{(numeric) Year to highlight in alternate color, defaults to current year.}

\item{title_lab}{(string) Title to override default chart title. Default title pulls region name from dataset attributes.}
}
\value{
Invisibly returns a ggplot2 object with daily temperature anomaly chart
}
\description{
Plots the daily temperatures and anomaly since 1979 retrieved using \code{get_dailytemp()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_temp} invisibly returns a ggplot2 object with a pre-defined daily temperature anomaly chart using data from \code{get_dailytemp}.
By default the chart is also displayed. Plots one line per year, as well as mean and anomaly (which may be disabled). Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Fetch temperature anomaly:
dailydata <- get_dailytemp()
#
# Plot output using package's built-in ggplot2 defaults
plot_dailytemp(dailydata)

# Don't plot anomaly shading and highight specific year
plot_dailytemp(anomaly = FALSE, current_year = 2012)

# Or just call plot_temp(), which defaults to get_temp() dataset
plot_dailytemp()

p <- plot_dailytemp(dailydata, print = FALSE)
# Modify plot such as: p + ggplot2::labs(title='Record Temperatures in 2023') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
