% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{k_max}
\alias{k_max}
\title{Constraint on the Number of Covariates}
\usage{
k_max(k)
}
\arguments{
\item{k}{an positive integer with \eqn{k \leq k_{max}} giving the maximum number of covariates to be used in the model.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Constraint on the maximum number of covariates to be used in the model.
}
\note{
\itemize{
  \item If an intercept is used, the upper bound on \eqn{k_{max} + 1} is given by number of columns of the model matrix.
  \item If no intercept is used, the upper bound on \eqn{k_{max}} is given by number of columns of the model matrix.    
}
}
\examples{
dat <- rhglm(100, c(1, 2, -3, 4, 5, -6))
hglm(y ~ ., constraints = k_max(3), data = dat)
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_equal}()},
\code{\link{group_inout}()},
\code{\link{group_sparsity}()},
\code{\link{include}()},
\code{\link{linear}()},
\code{\link{lower}()},
\code{\link{pairwise_sign_coherence}()},
\code{\link{rho_max}()},
\code{\link{sign_coherence}()},
\code{\link{upper}()}
}
\concept{Constraint-Constructors}
