% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.hpiindex}
\alias{plot.hpiindex}
\title{Plot method for `hpiindex` object}
\usage{
\method{plot}{hpiindex}(x, show_imputed = FALSE, smooth = FALSE, ...)
}
\arguments{
\item{x}{Object to plot of class `hpiindex``}

\item{show_imputed}{default = FALSE; highlight the imputed points}

\item{smooth}{default = FALSE; plot the smoothed index}

\item{...}{Additional Arguments}
}
\value{
`plotindex` object inheriting from a ggplot object
}
\description{
Specific plotting method for hpiindex objects
}
\examples{

 # Load data
 data(ex_sales)

 # With a raw transaction data.frame
 rt_data <- rtCreateTrans(trans_df = ex_sales,
                          prop_id = 'pinx',
                          trans_id = 'sale_id',
                          price = 'sale_price',
                          periodicity = 'monthly',
                          date = 'sale_date')

 # Create model object
 hpi_model <- hpiModel(hpi_df = rt_data,
                       estimator = 'base',
                       log_dep = TRUE)

 # Create Index
 hpi_index <- modelToIndex(hpi_model,
                           max_period = 84)

 # Make Plot
 plot(hpi_index)

}
