% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfModel.R
\name{rfModel}
\alias{rfModel}
\title{Estimate random forest model for index creation}
\usage{
rfModel(estimator, rf_df, rf_spec, ntrees = 200, seed = 1, ...)
}
\arguments{
\item{estimator}{Type of model to estimates (pdp)}

\item{rf_df}{Transactions dataset from hedCreateSales()}

\item{rf_spec}{Model specification (`formula` object)}

\item{ntrees}{[200] Set number of trees to use}

\item{seed}{[1] Random seed for reproducibility}

\item{...}{Additional arguments}
}
\value{
`rfmodel` object: model object of the estimator (ex.: `lm`)
}
\description{
Estimate coefficients for an index via the random forest approach (generic method)
}
\section{Further Details}{

`estimator` argument must be in a class of 'pdp'
This function is not generally called directly, but rather from `hpiModel()`
}

\examples{
 # Load example data
 data(ex_sales)

 # Create hedonic data
 hed_data <- hedCreateTrans(trans_df = ex_sales,
                           prop_id = 'pinx',
                           trans_id = 'sale_id',
                           price = 'sale_price',
                           date = 'sale_date',
                           periodicity = 'monthly')

 # Estimate Model
 rf_model <- rfModel(estimator = structure('pdp', class = 'pdp'),
                     rf_df = hed_data,
                     rf_spec = as.formula(log(price) ~ baths + tot_sf),
                     ntrees = 10,
                     sim_count = 1)

}
