% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{LDsire}
\alias{LDsire}
\title{Calculation of paternal LD matrix}
\usage{
LDsire(inMat, pos_chr, family, map_fun = "haldane")
}
\arguments{
\item{inMat}{[MATRIX] Haplotype matrix for sires for all chromosomes.}

\item{pos_chr}{[LIST] The marker positions in Morgan on chromosomes.}

\item{family}{[VECTOR] Which family (sire) should be processed?
Vector with consecutive entries of the form 1:2, 3:4, 5:6 and so on,
linking to haplotypes (rows in inMat) of the corresponding sire}

\item{map_fun}{[haldane, kosambi] The mapping function applied.}
}
\value{
Ds
\describe{
  \item{\code{Ds}}{(p x p) matrix of paternal LD}
}
}
\description{
Matrix containing linkage disequilibrium between marker pairs
  on paternal gametes is set up from sire haplotypes and genetic-map
  information for each half-sib family.
}
\details{
The function generates a block diagonal sparse matrix based on
  Matrix::bdiag. Use as.matrix() to obtain a regular one.
}
\examples{
 data(testdata)
 LDfam2 <- LDsire(H.sire, pos.chr, family = 3:4)
}
