% Generated by roxygen2 (4.0.2): do not edit by hand
\name{txtInt}
\alias{txtInt}
\title{SI or English formatting of an integer}
\usage{
txtInt(x, language = "en", html = TRUE, ...)
}
\arguments{
  \item{x}{The integer variable}

  \item{language}{The ISO-639-1 two-letter code for the
  language of interest. Currently only english is
  distinguished from the ISO format using a ',' as the
  separator.}

  \item{html}{If the format is used in html context then
  the space should be a non-breaking space, \code{&nbsp;}}

  \item{...}{Passed to \code{\link[base]{format}}}
}
\value{
\code{string}
}
\description{
English uses ',' between every 3 numbers while the SI
format recommends a ' ' if x > 10^4. The scientific form
10e+? is furthermore avoided.
}
\examples{
txtInt(123)
txtInt(1234)
txtInt(12345)
txtInt(123456)
}

