% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_apis.R, R/list_endpoints.R,
%   R/list_params.R
\name{list_apis}
\alias{list_apis}
\alias{list_endpoints}
\alias{list_params}
\title{List available Hub'Eau APIs, endpoints and filter parameters}
\usage{
list_apis()

list_endpoints(api)

list_params(api, endpoint)
}
\arguments{
\item{api}{a \link{character} name of the API (e.g.: "indicateurs_services", "prelevements"...), see example for available APIs}

\item{endpoint}{a \link{character} name of the endpoint, see example for available endpoints in an API}
}
\value{
\link{character} \link{vector} of APIs, endpoints or filter parameters
}
\description{
\code{list_apis()} returns the list of available APIs in the package.

\code{list_endpoints()} returns the list of available endpoints for an API.

\code{list_params()} returns the list of available parameters for an API endpoint.
}
\details{
The listed APIs correspond to the term \verb{[API]} used in the name of the
functions \verb{get_[API]_[endpoint]} used for querying the APIs.
}
\examples{
# To get the available APIs in the package
list_apis()

# To get the available endpoints in an API
list_endpoints("prelevements")

# To get available parameters in endpoint "chroniques" of the API "prelevements"
list_params(api = "prelevements", endpoint = "chroniques")

}
