% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{chrNums}
\alias{chrNums}
\title{Extract chromosome numbers from GRanges/RangedData}
\usage{
chrNums(ranged, warn = FALSE, table.out = FALSE, table.in = NULL)
}
\arguments{
\item{ranged}{GRanges or RangedData object}

\item{warn}{logical, whether to display a warning when non autosomes are converted to numbers}

\item{table.out}{logical, whether to return a lookup table of how names matched to integers}

\item{table.in}{data.frame/matrix, col 1 is the raw text names, col 2 is the integer that should be assigned,
col 3 is the cleaned text (of col 1) with 'chr' removed. the required form is outputted by this function if
you set 'table.out=TRUE', so the idea is that to standardize coding amongst several RangedData objects you
can save the table each time and ensure future coding is consistent with this. Note that chromosomes 1-22, X,
Y, XY, and MT are always allocated the same integer, so table is only useful where there are extra NT, COX, HLA
regions, etc.}
}
\value{
a set of integers of length equal to the number of unique chromosomes in the ranged data.
}
\description{
Sometimes chromosomes are codeds as 1:22, sometimes there is also X,Y, etc, sometimes it's 
chr1, ch2, etc. This function extracts the set of chromosome labels used by a ranged object 
(ie, GRanges or RangedData) and converts the labels to numbers in a consistent way, so
1:22, X, Y, XT, MT ==> 1:26, and optionally you can output the conversion table of codes to
numbers, then input this table for future conversions to ensure consistency.
}
\examples{
require(genoset)
gg <- rranges(1000)
chrNames(gg); chrNums(gg)
gg <- rranges(1000,chr.pref=TRUE) # example where chromosomes are chr1, chr2, ...
chrNames(gg); chrNums(gg)
lookup <- chrNums(gg,table.out=TRUE)
lookup
gg2 <- rranges(10)
chrNums(gg2,table.in=lookup) # make chromosome numbers using same table as above
}

