% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{recomWindow}
\alias{recomWindow}
\title{Extend an interval or SNP by distance in centimorgans (recombination distance)}
\usage{
recomWindow(ranges = NULL, chr = NA, start = NA, end = start,
  window = 0.1, bp.ext = 0, rec.map = NULL, info = TRUE)
}
\arguments{
\item{ranges}{optional GRanges or RangedData object describing positions for which we want to
generate windows, removing the need to enter chr, start and end}

\item{chr}{character, an optional vector of chromosomes to combine with 'start' and 'end'
to describe positions for which to generate recombination windows}

\item{start}{integer, an vector of start points for chromosome ranges}

\item{end}{integer, an vector of end points for chromosome ranges}

\item{window}{numeric, number of centimorgans to extend the window either side of
the range or location (can be a fraction)}

\item{bp.ext}{numeric, optional number of base-pairs to extend the window by in addition
to the centimorgan extension}

\item{rec.map}{recombination map object (list of 22 data.frames) generated using 
'get.recombination.map()'; if you are performing many of these operations, loading this 
object into your workspace and passing it on to this function will save loading it each 
time, and provide a speed advantage. Only use an object generated by get.recombination.map(),
 as otherwise the results will almost certainly be meaningless.}

\item{info}{logical, whether to display the derived window size and number of hapmap SNPs within
the window for each window derived}
}
\description{
It is straightforward to extend a genomic interval or position by a number of basepairs, or
a percentage, but extending by recombination units of centimorgans is more involved, requiring
annotation lookup. This function streamlines this process.
This function makes use of recombination rate hapmap reference files to calculate 
recombination distances for genome locations, in centimorgans. For a given position
(or vector), a window can be returned of a given extension on either side of the position,
for instance, 1 centimorgan to the left, and to the right of a SNP, giving a 2 centimorgan
range as a result. Warning - this function only uses build hg18/36, so please convert to
build 36 coordinates before using this function.
}
\examples{
\donttest{
# not run, as initial download of the recombination map takes nearly a minute #
recomWindow(chr=11,start=10000000,end=10000000,window=1,bp.ext=10000)
rd <- RangedData(ranges=IRanges(start=c(1.5,10.1)*10^7, end=c(1.55,10.1)*10^7),space=c(2,10))
rd # show original data
recomWindow(rd) # now extended by the interval
recomWindow(as(rd,"GRanges"),info=FALSE) # also works for GRanges
}
}
\seealso{
\code{\link{get.recombination.map}}, \code{\link{get.nearby.snp.lists}}, \code{\link{expand.nsnp}}
}
\author{
Chris Wallace and Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
