% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{left_border}
\alias{left_border}
\alias{left_border<-}
\alias{set_left_border}
\alias{left_border.huxtable}
\alias{left_border<-.huxtable}
\title{Get or Set Left Border}
\usage{
left_border(ht)
left_border(ht) <- value
set_left_border(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector or matrix giving border widths. Set to 0 for no border. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{left_border}, the \code{left_border} attribute.
For \code{set_left_border}, the \code{ht} object.
}
\description{
Functions to get or set the left border property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
left_border(ht) <-  1
left_border(ht)
print_screen(ht)
}
\seealso{
Other borders: \code{\link{bottom_border}},
  \code{\link{right_border}}, \code{\link{top_border}}
}
