% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{huxtable-package}
\alias{huxtable-package}
\title{Huxtable: simply create LaTeX and HTML tables}
\description{
Huxtable is a package for creating HTML and LaTeX tables. It provides similar
functionality to xtable, with a simpler interface.
}
\details{
To create a huxtable object, use \code{\link[=huxtable]{huxtable()}} or \code{\link[=as_huxtable]{as_huxtable()}}.

For more information, see \href{https://hughjonesd.github.io/huxtable/}{the website} or
read the vignette with \code{vignette('huxtable')}.
}
\section{Package options}{

\itemize{
\item \code{options('huxtable.add_colnames')} sets the default value for \code{add_colnames} in
\code{\link[=huxtable]{huxtable()}} and \code{\link[=as_huxtable]{as_huxtable()}}. If it is unset, \code{add_colnames} defaults to
\code{FALSE}; in a future release, the default will become \code{TRUE}.
\item \code{options('huxtable.print')} sets the print method for huxtable objects. See \code{\link[=print.huxtable]{print.huxtable()}}.
\item \code{options('huxtable.color_screen')}. If \code{TRUE} and package \code{crayon} is available, huxtables
will be printed in color on screen.
\item \code{options('huxtable.knit_print_df')}. If \code{TRUE} (the default), data frames in knitr will be
pretty-printed using huxtable.
\item \code{options('huxtable.knit_print_df_theme')}. A one-argument function applied to theme the
huxtableized data frame before printing in knitr. Defaults to \code{\link[=theme_plain]{theme_plain()}}.
\item \code{options('huxtable.autoformat')} sets the default value for \code{autoformat} in \code{\link[=huxtable]{huxtable()}} and
\code{\link[=as_huxtable]{as_huxtable()}}. It defaults to \code{TRUE}.
\item \code{options('huxtable.autoformat_number_format')} and \code{options('huxtable.autoformat_align')} are
lists. The list names are base R classes. \code{\link[=huxtable]{huxtable()}} with \code{autoformat = TRUE} will set
\code{number_format()} and \code{align()} for data columns according to the corresponding list values.
}

For example, to center-align \code{Date} objects you could set \code{"huxtable.autoformat_align"} to
something like \code{list(..., Date = "center", ...)}.
}

