% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{rotation}
\alias{rotation}
\alias{rotation<-}
\alias{set_rotation}
\alias{map_rotation}
\title{Text rotation}
\usage{
rotation(ht)
rotation(ht) <- value
set_rotation(ht, row, col, value, byrow = FALSE)
map_rotation(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector. Anti-clockwise from the x axis, so 0 is left to right, 90 is going up, etc.

Set to \code{NA} to reset to the default, which is \code{0}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{rotation}, the \code{rotation} property.
For \code{set_rotation} and \code{map_rotation}, the modified huxtable.
}
\description{
Functions to get or set the \emph{text rotation} property of huxtable cells.
}
\details{
You will probably need to set \code{\link[=col_width]{col_width()}} and \code{\link[=row_height]{row_height()}} explicitly
to achieve a nice result, in both HTML and LaTeX.
}
\examples{

rotation(jams) <-  90
rotation(jams)


jams2 <- set_rotation(jams,
      90)
rotation(jams2)

jams3 <- set_rotation(jams,
      2:3, 1, 90)
rotation(jams3)

jams4 <- map_rotation(jams,
      by_rows(
        90,
        270)
      )
rotation(jams4)
}
