% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atmos_properties.R
\name{atmosprops}
\alias{atmosprops}
\alias{atmtemp}
\alias{atmpres}
\alias{atmdens}
\title{Functions to calculate ICAO standard atmospheric properties: temperature, 
density, and pressure.}
\usage{
atmtemp(alt = NULL, units = c("SI", "Eng"), ret_units = FALSE)

atmpres(alt = NULL, units = c("SI", "Eng"), ret_units = FALSE)

atmdens(alt = NULL, units = c("SI", "Eng"), ret_units = FALSE)
}
\arguments{
\item{alt}{the altitude (above mean sea level). If excluded, sea level is assumed [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units.}

\item{ret_units}{If set to TRUE the value(s) returned are of class \code{units} with
units attached to the value. [Default is FALSE]}
}
\value{
the temperature of air for the standard atmosphere for the
  atmtemp function [\eqn{^{\circ}C}{C} or \eqn{^{\circ}F}{F}]

the absolute pressure of air for the standard atmosphere for the
  atmpres function [\eqn{N m^{-2}}{N/m^2} or \eqn{lbf ft^{-2}}{lbf/ft^2}]

the density of air for the standard atmosphere for the
  atmdens function [\eqn{{kg}\,{m^{-3}}}{kg/m^3} or \eqn{{slug}\,{ft^{-3}}}{slug/ft^3}]
}
\description{
Functions to calculate ICAO standard atmospheric properties: temperature, 
density, and pressure.
}
\examples{

#Find standard atmospheric temperature at altitude 8000 m
atmtemp(alt = 8000, units = 'SI')

#Find standard atmospheric pressure assuming default altitude of zero (sea-level)
atmpres(units = 'Eng', ret_units = TRUE)

#Find standard atmospheric density at altitude 15000 ft 
atmdens(alt = 15000, units = 'Eng')

}
\author{
Ed Maurer
}
