% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.hyper_gam.R
\name{predict.hyper_gam}
\alias{predict.hyper_gam}
\title{Prediction of \link{hyper_gam} Model}
\usage{
\method{predict}{hyper_gam}(
  object,
  newdata = object$data,
  sign_adjusted = TRUE,
  sgn = if (sign_adjusted) sign(cor_xy(object, probs = 0.5)) else 1,
  ...
)
}
\arguments{
\item{object}{an \link{hyper_gam} model}

\item{newdata}{test \link[spatstat.geom]{hyperframe}, with at least
the response \eqn{y^{\text{new}}} and
the \link[base]{double}-hypercolumn \eqn{X^{\text{new}}}
tabulated on the same grid as the training hypercolumn \eqn{X}.
If missing, the training data \code{object$data} will be used.}

\item{sign_adjusted}{\link[base]{logical} scalar, default \code{TRUE}}

\item{sgn}{(internal use) \link[base]{numeric} scalar, either \code{-1} or \code{1},
the \link[base]{sign} of \code{\link[=cor_xy]{cor_xy()}} return, to be used in the sign adjustment}

\item{...}{additional parameters, currently not in use.}
}
\value{
Function \code{\link[=predict.hyper_gam]{predict.hyper_gam()}} returns a
\link[base]{double} \link[base]{vector}.
}
\description{
Prediction of \link{hyper_gam} model.
}
\details{
Function \code{\link[=predict.hyper_gam]{predict.hyper_gam()}} computes
the sign-adjusted \link[mgcv]{gam} model prediction.
The sign-adjustment ensures
that the return
is positively associated with the \strong{training} hypercolumn \eqn{X}
at the selected tabulating grid.
}
\keyword{internal}
