% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registerBrick.R
\name{registerBrick}
\alias{registerBrick}
\title{Hyperspectral Image Registration (Translation)}
\usage{
registerBrick(
  Brick,
  ref_layer = 1,
  layers = "all",
  ncells = 24,
  orient = 8,
  cl = NULL
)
}
\arguments{
\item{Brick}{An object of class \code{RasterBrick} or \code{RasterStack}
(from package \link{raster}), containing multiple layers (spectral bands).}

\item{ref_layer}{An integer indicating which layer (spectral band) should
be used as reference ('master') to register all the others from. Default is
1, the first band.}

\item{layers}{Either the character \code{"all"} (default), which indicates
that all bands should be registered using \code{ref_layer} as reference,
or a vector of integers specifying which bands to register.}

\item{ncells}{An integer giving the number of cells to compute the oriented
gradients of the HOG descriptor. Default is 24. See \code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}.}

\item{orient}{An integer giving the number of orientations to compute the
oriented gradients of the HOG descriptor. Default is 8. See \code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}.}

\item{cl}{An integer indicating the number of parallel processes or an
object created by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}. Default if \code{NULL}.}
}
\value{
An object of the same classe as the input \code{slave}, with
the fixed extent.
}
\description{
Hyperspectral image acquisition normaly causes spatial misalignment between
the spectral bands (layers) due to both equipment (such as band-to-band
recording delay) and external factors (e.g. sensor vibrations). In this case,
a geometric correction is necessary for remote sensing applications such
as combining/merging spectral bands. This function uses the HOG (Histogram
of Oriented Gradient) descriptor in order to find the optimal translations
(xy shift) on multiple 'slave' bands to be spatially align with a 'master'
(reference) band. Parallel processing is allowed.
}
\details{
This should be used carefully, as rotation affects the spatial
dimensions. The affine parameters are estimated using a general
optimization algorithm.
}
\examples{
path <- system.file('exdata', 'obory.dat', package = 'hyperbrick')
dpath <- system.file('exdata', 'obory_dark.dat', package = 'hyperbrick')
im <- buildBrick(path, hFOV = 36.8, vFOV = 36.8, height = 45,
                 ref_layer = 35, spectral_feature = 'radiance',
                 dark_path = dpath)
print(im)
plotRGB(im, r = 63, g = 34, b = 11, stretch = 'lin')

imreg <- registerBrick(im, ref_layer = 35, layers = c(63, 34, 11))
imreg
plotRGB(imreg, stretch = 'lin')

}
\seealso{
\code{\link[OpenImageR:HOG]{OpenImageR::HOG()}}, \code{\link[=registerBand]{registerBand()}}, \code{\link[=registerBand3]{registerBand3()}},
\code{\link[=buildBrick]{buildBrick()}}
}
