% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergate.R
\name{subset_matrix_hg}
\alias{subset_matrix_hg}
\title{subset_matrix_hg}
\usage{
subset_matrix_hg(gate, xp)
}
\arguments{
\item{gate}{a return from hypergate}

\item{xp}{Expression matrix used for gate}
}
\description{
Returns a boolean vector whose TRUE elements correspond to events inside the hyperrectangle
}
\examples{
data(Samusik_01_subset)
xp=Samusik_01_subset$xp_src[,Samusik_01_subset$regular_channels]
gate_vector=Samusik_01_subset$labels
hg=hypergate(xp=xp,gate_vector=gate_vector,level=23,delta_add=0.01)
gating_state=subset_matrix_hg(hg,xp)
gating_state=ifelse(gating_state,"Gated in","Gated out")
target=ifelse(gate_vector==23,"Target events","Others")
table(gating_state,target)
}
