% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARt.R
\name{IAR.t}
\alias{IAR.t}
\title{Maximum Likelihood Estimation of the IAR-T model}
\usage{
IAR.t(y, sT, nu = 3)
}
\arguments{
\item{y}{Array with the time series observations}

\item{sT}{Array with the irregular observational times}

\item{nu}{degrees of freedom}
}
\value{
A list with the following components:
\itemize{
\item{phi}{ MLE of the phi parameter of the IAR-T model.}
\item{sigma}{ MLE of the sigma parameter of the IAR-T model.}
\item{ll}{ Value of the negative log likelihood evaluated in phi and sigma.}
}
}
\description{
Maximum Likelihood Estimation of the IAR-T model.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
y<-IARt.sample(n,0.9,st,sigma2=1,nu=3)
model<-IAR.t(y$y, sT=st)
phi=model$phi
sigmaest=model$sigma
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARt.sample}}, \code{\link{IAR.phi.t}}
}
