% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gentime.R
\name{gentime}
\alias{gentime}
\title{Generating Irregularly spaced times}
\usage{
gentime(
  n,
  distribution = "expmixture",
  lambda1 = 130,
  lambda2 = 6.5,
  p1 = 0.15,
  p2 = 0.85,
  a = 0,
  b = 1
)
}
\arguments{
\item{n}{A positive integer. Length of observation times.}

\item{distribution}{Distribution of the observation times that will be generated. Default value is "expmixture" for a mixture of exponential distributions. Alternative distributions are "uniform", "exponential" and "gamma".}

\item{lambda1}{Mean (1/rate) of the exponential distribution or the first exponential distribution in a mixture of exponential distributions.}

\item{lambda2}{Mean (1/rate) of the second exponential distribution in a mixture of exponential distributions.}

\item{p1}{Weight of the first exponential distribution in a mixture of exponential distributions.}

\item{p2}{Weight of the second exponential distribution in a mixture of exponential distributions.}

\item{a}{Shape parameter of a gamma distribution or lower limit of the uniform distribution.}

\item{b}{Scale parameter of a gamma distribution or upper limit of the uniform distribution.}
}
\value{
Array with irregularly spaced observations times
}
\description{
Function to generate irregularly spaced times from a mixture of exponential distributions.
}
\examples{
st<-gentime(n=100)
st<-gentime(n=100,distribution="uniform")
st<-gentime(n=100,distribution="gamma",a=1,b=1)
st<-gentime(n=100,distribution="exponential",lambda1=1)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{IARsample}}
}
