% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.summary.R
\name{sim.summary}
\alias{sim.summary}
\title{Visualize simulation results (Stages 1&2)}
\usage{
sim.summary(sims, print = TRUE)
}
\arguments{
\item{sims}{output from sim.trials}

\item{print}{logical specifying whether to print tables in console}
}
\value{
Printed tables and a list of the following objects:
\itemize{
\item pct.treated - IQR (25th percentile, median, 75th percentile) of 
percent of subjects treated at each dose level
\item efficacy - IQR of efficacy observed at each dose level
}
}
\description{
Results from simulated trials (using \code{sim.trials()} function) 
displayed in tabular and/or graphical format
}
\examples{
# Number of pre-specified dose levels
dose <- 5

# Vector of true toxicities associated with each dose
dose.tox <- c(0.05, 0.10, 0.20, 0.35, 0.45)      
 
# Acceptable (p_yes) and unacceptable (p_no) DLT rates used for establishing safety
p_no <- 0.40                                     
p_yes <- 0.15    

# Likelihood-ratio (LR) threshold
K <- 2                                          

# Cohort size used in stage 1
coh.size <- 3 

# Vector of true mean efficacies per dose (here mean percent persistence per dose)
m <- c(5, 15, 40, 65, 80)   # MUST BE THE SAME LENGTH AS dose.tox                  

# Efficacy(equal) variance per dose
v <- rep(0.01, 5) 

# Total sample size (stages 1&2)                            
N <- 25                                        

# Stopping rule: if dose 1 is the only safe dose, allocate up to 9 pts.
stop.rule <- 9 

simulations = sim.trials(numsims = 100, dose, dose.tox, p1 = p_no, p2 = p_yes, K, 
coh.size, m, v, N, stop.rule = stop.rule, cohort = 1, samedose = TRUE, nbb = 100)

summary = sim.summary(simulations)
 
}
