% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_read_summary.R
\name{ifcb_read_summary}
\alias{ifcb_read_summary}
\title{Read and Summarize Classified IFCB Data}
\usage{
ifcb_read_summary(
  summary,
  hdr_directory = NULL,
  biovolume = FALSE,
  threshold = "opt",
  use_python = FALSE
)
}
\arguments{
\item{summary}{A character string specifying the path to the .mat summary file or a list generated by \code{ifcb_summarize_class_counts}.}

\item{hdr_directory}{A character string specifying the path to the directory containing header (.hdr) files. Default is NULL.}

\item{biovolume}{A logical indicating whether the file contains biovolume data. Default is FALSE.}

\item{threshold}{A character string specifying the threshold type for counts and biovolume. Options are "opt" (default), "adhoc", and "none".}

\item{use_python}{Logical. If \code{TRUE}, attempts to read the \code{.mat} file using a Python-based method. Default is \code{FALSE}.}
}
\value{
A data frame containing the summary information including file list, volume analyzed, species counts, optionally biovolume, and other metadata.
}
\description{
This function reads a MATLAB .mat file containing aggregated and classified IFCB (Imaging FlowCytobot)
data generated by the \code{countcells_allTBnew_user_training} function from the \code{ifcb-analysis} repository (Sosik and Olson 2007),
or a list of classified data generated by \code{ifcb_summarize_class_counts}.
It returns a data frame with species counts and optionally biovolume information based on specified thresholds.
}
\details{
If \code{use_python = TRUE}, the function tries to read the \code{.mat} file using \code{ifcb_read_mat()}, which relies on \code{SciPy}.
This approach may be faster than the default approach using \code{R.matlab::readMat()}, especially for large \code{.mat} files.
To enable this functionality, ensure Python is properly configured with the required dependencies.
You can initialize the Python environment and install necessary packages using \code{ifcb_py_install()}.

If \code{use_python = FALSE} or if \code{SciPy} is not available, the function falls back to using \code{R.matlab::readMat()}.
}
\examples{
\dontrun{
summary_data <- ifcb_read_summary("path/to/summary_file.mat", biovolume = TRUE, threshold = "opt")
print(summary_data)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\url{https://github.com/hsosik/ifcb-analysis}
}
