% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{icd_comorbid_mat_to_df}
\alias{icd_comorbid_mat_to_df}
\title{convert comorbidity data frame from matrix}
\usage{
icd_comorbid_mat_to_df(x, visit_name = "visit_id",
  stringsAsFactors = getOption("stringsAsFactors"))
}
\arguments{
\item{x}{Matrix of comorbidities, with row and columns names defined}

\item{visit_name}{Single character string with name for new column in output
data frame. Everywhere else, \code{visit_name} describes the input data,
but here it is for output data.}

\item{stringsAsFactors}{Single logical value, describing whether the resulting data frame should have strings, e.g.
\code{visit_id} converted to factor. Default is to follow the current session option. This is identical to the
argument used in, among other base functions \code{as.data.frame}.}
}
\description{
convert matrix of comorbidities into data frame, preserving visit_name
information
}
\examples{
longdf <- icd_long_data(
            visit_id = c("a", "b", "b", "c"),
            icd9 = as.icd9(c("441", "4424", "443", "441")))
mat <- icd9_comorbid_elix(longdf)
class(mat)
typeof(mat)
rownames(mat)
df.out <- icd_comorbid_mat_to_df(mat)
stopifnot(is.data.frame(df.out))
# output data frame has a factor for the visit_name column
stopifnot(identical(rownames(mat), as.character(df.out[["visit_id"]])))
df.out[, 1:4]
# when creating a data frame like this, stringsAsFactors uses
# the system-wide option you may have set e.g. with
# options("stringsAsFactors" = FALSE).
is.factor(df.out[["visit_id"]])
}

