% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{icd_sort}
\alias{icd_sort}
\alias{icd_sort.default}
\alias{icd_sort.icd10}
\alias{icd_sort.icd9}
\title{Sort short-form ICD-9 codes}
\usage{
icd_sort(x, ...)

\method{icd_sort}{default}(x, short_code = icd_guess_short(x), ...)

\method{icd_sort}{icd10}(x, short_code = NULL, ...)

\method{icd_sort}{icd9}(x, short_code = icd_guess_short(x), ...)
}
\arguments{
\item{x}{vector of ICD codes to sort}

\item{...}{arguments passed on to other functions}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}
}
\value{
sorted vector of ICD-9 codes. Numeric, then E codes, then V codes.
}
\description{
Sorts lists of numeric only, V or E codes. Note that a simple numeric sort
does not work for ICD-9 codes, since "162" > "1620", and also V codes precede
E codes.
}
\details{
Implementation used fast built-in sort, then shuffles the E codes to
  the end.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Guess whether ICD-9 or ICD-10 (or possibly sub-type in
the future) then sort based on that type. ICD-10 codes, note that setting
\code{short} is unnecessary and ignored.

\item \code{icd10}: Sort ICD-10 codes, note that setting \code{short} is
unnecessary and ignored.

\item \code{icd9}: sort ICD-9 codes respecting numeric, then 'V', then 'E'
codes, and accounting for leading zeroes. Will return a factor if a factor is given.
}}
\keyword{internal}
\keyword{manip}

