% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simplify_map_lex}
\alias{simplify_map_lex}
\title{Internal function to simplify a comorbidity map by only including codes
which are parents, or identical to, a given list of codes.}
\usage{
simplify_map_lex(pt_codes, map)
}
\arguments{
\item{map}{named list containing vectors of ICD-9 codes. E.g. the AHRQ ICD-9
comorbidities, contains \code{list(OBESE = c("2780", "27800", "27801",
"27803", "V8554", "79391", "64910", "64911", "64912", "64913", "64914",
"V8530", "V8531", "V8532", "V8533", "V8534", "V8535", "V8536", "V8537",
"V8538", "V8539", "V8541", "V8542", "V8543", "V8544", "V8545" ), DEPRESS =
c("3004", "30112", "3090", "3091", "311"))} amongst other longer groups.}

\item{x}{Character vector (not factor)}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}

\item{icd_name}{The name of the column in the \code{data.frame} which
contains the ICD codes. This is a character vector of length one. If it is
\code{NULL}, \code{icd9} will attempt to guess the column name, looking for
progressively less likely possibilities until it matches a single column.
Failing this, it will take the first column in the data frame. Specifying
the column using this argument avoids the guesswork.}
}
\description{
Specifically, this is useful for ICD-10 codes where there are a huge number
of possible codes, but we do not want to make a comorbidity map with such a
large number of codes in it.
}
\examples{
# one exact match, next cmb parent code, next cmb child code
icd10 <- as.icd10(c("I0981", "A520", "I26019"))
pts <- data.frame(visit_id = c("a", "b", "c"), icd10)
simple_map <- icd:::simplify_map_lex(icd10, icd10_map_ahrq)
stopifnot(simple_map$CHF == "I0981")
stopifnot(simple_map$PHTN != character(0))
stopifnot(simple_map$PVD == "I26019")

umap <- icd:::simplify_map_lex(uranium_pathology$icd10, icd10_map_ahrq)
head(icd:::comorbid_common(uranium_pathology, icd10_map_ahrq,
                           visit_name = "case", icd_name = "icd10",
                           comorbid_fun = icd:::comorbidMatMul))

}
\seealso{
\url{https://github.com/s-u/fastmatch/blob/master/src/fastmatch.c}
}
\keyword{internal}
