% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{print.icd9}
\alias{print.icd9}
\alias{print.icd10}
\title{Print ICD codes and comorbidity maps cleanly}
\usage{
\method{print}{icd9}(x, verbose = FALSE, ...)

\method{print}{icd10}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{ICD codes to be printed}

\item{verbose}{Annotate based on code attributes, e.g., decimal versus short
codes.}
}
\description{
Print ICD codes and comorbidity maps cleanly
}
\examples{
x <- structure(
  c("40201", "2258", "7208", "25001", "34400", "4011", "4011", NA),
  class = c("icd9cm", "icd9", "character"),
  icd_short_diag = TRUE)
print(x)
print(x, verbose = TRUE)
# as.factor drops any 'icd' classes
print(as.factor(x), verbose = TRUE)
u <- uranium_pathology[1:10, "icd10"]
print(u)
print(u, verbose = TRUE)
# as.character will unclass the 'icd' classes
print(as.character(u), verbose = TRUE)
}
\keyword{internal}
