% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{charlson_from_comorbid}
\alias{charlson_from_comorbid}
\title{Calculate Charlson scores from precomputed Charlson comorbidities}
\usage{
charlson_from_comorbid(x, visit_name = NULL, hierarchy = FALSE,
  scoring_system = c("original", "charlson", "quan"))
}
\arguments{
\item{x}{data.frame or matrix, typically the output of a comorbidity
calculation which uses the Charlson categories, e.g.
\code{comorbid_quan_deyo}}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}

\item{hierarchy}{single logical value, default is \code{FALSE}. If
\code{TRUE}, will drop \code{DM} if \code{DMcx} is present, etc.}

\item{scoring_system}{One of \code{original}, \code{charlson}, or
\code{quan}. The first two will give the original Charlson weights for each
comorbidity, whereas \code{quan} uses the updated weights from Quan 2011.}
}
\description{
Calculate Charlson scores from precomputed Charlson comorbidities, instead
of directly from the ICD codes. This is useful if the comorbidity calculation
is time consuming. Commonly, both the Charlson comorbidities and the Charlson
scores will be calculated, and this function provides just that second step.
}
