% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{wide_vs_long}
\alias{wide_vs_long}
\alias{as.icd_long_data}
\alias{as.icd_wide_data}
\alias{icd_long_data}
\alias{icd_wide_data}
\title{Set the ICD data structure class of a \code{matrix} or \code{data.frame}.}
\usage{
as.icd_long_data(x, warn = TRUE)

as.icd_wide_data(x, warn = TRUE)

icd_long_data(..., warn = TRUE)

icd_wide_data(x, ..., warn = TRUE)
}
\arguments{
\item{x}{Input data is a \code{matrix}, \code{data.frame}, or a class that
inherits one of these base structures, such as a \code{tibble}.}

\item{warn}{Single logical, if \code{TRUE}, the default, a warning will be
shown if changing class between long and wide types.}

\item{...}{Data used to construct data frame before setting the appropriate
class.}
}
\description{
These functions take your patient data, and allow you to describe whether it
is wide or long. \code{icd} never requires you do this, but it may help avoid
errors, especially if you have atypical data that might confuse \code{icd}'s
heuristics.
}
\section{Functions}{
\itemize{
\item \code{as.icd_long_data}: Set class on a matrix or data.frame to
\code{icd_long_data}. To convert wide to long data, use
\code{\link{wide_to_long}}.

\item \code{as.icd_wide_data}: Construct a \code{data.frame}, adding the
\code{icd_long_data} class.

\item \code{icd_long_data}: Construct a \code{data.frame}, adding the
\code{icd_long_data} class.

\item \code{icd_wide_data}: Construct a \code{data.frame}, adding the
\code{icd_wide_data} class.
}}

\section{Long and Wide Formats}{
 As is common with many data sets, key
  variables can be concentrated in one column or spread over several. Tools
  format of clinical and administrative hospital data, we can perform the
  conversion efficiently and accurately, while keeping some metadata about
  the codes intact, e.g. whether they are ICD-9 or ICD-10.
}

\section{Data structure}{
 Long or wide format ICD data are all expected to be
  in a data frame. The \code{data.frame} itself does not carry any ICD
  classes at the top level, even if it only contains one type of code;
  whereas its constituent columns may have a class specified, e.g.
  \code{icd9} or \code{icd10who}.
}

\section{Conversion}{
 To convert between long and wide data, use
  \code{\link{long_to_wide}} or \code{\link{wide_to_long}}. Conversion
  functions in other packages, such as \code{ddplyr} will work, too, but will
  need some work to account for the typical structure of patient data and
  diagnostic codes. This is not done with \code{ddplyr}, \code{data.table}
  etc because it would add a big dependency burden. This package aims to be
  agnostic and use base R as much as possible.
}

\examples{
(w <- icd_wide_data(
  id = c(1, 2, 3),
  dx01 = c("100", "441", "V20"),
  dx02 = c("E9981", "V10", "44004")
))
wide_to_long(w)
class(uranium_pathology)
class(vermont_dx)
}
\seealso{
\code{\link{long_to_wide}} and \code{\link{wide_to_long}}

Other ICD data types: 
\code{\link{as.comorbidity_map}()},
\code{\link{set_icd_class}}

Other ICD data types: 
\code{\link{as.comorbidity_map}()},
\code{\link{set_icd_class}}

Other ICD data types: 
\code{\link{as.comorbidity_map}()},
\code{\link{set_icd_class}}
}
\concept{ICD data types}
