% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_bayes.R
\name{ic_bayes}
\alias{ic_bayes}
\title{Bayesian Regression  Models for Interval Censored Data}
\usage{
ic_bayes(formula, data, logPriorFxn = function(x) return(0), model = "ph",
  dist = "weibull", weights = NULL, controls = bayesControls(),
  useMCores = F)
}
\arguments{
\item{formula}{Regression formula. Response must be a \code{Surv} object of type
\code{'interval2'} or \code{cbind}. See details.}

\item{data}{Dataset}

\item{logPriorFxn}{An R function that computes the log prior}

\item{model}{What type of model to fit. Current choices are "\code{ph}" (proportional hazards), 
"\code{po}" (proportional odds) or "\code{aft}" (accelerated failure time)}

\item{dist}{What baseline parametric distribution to use. See details for current choices}

\item{weights}{vector of case weights. Not standardized; see details}

\item{controls}{Control parameters passed to samplers}

\item{useMCores}{Should multiple cores be used? Each core is used to run a single chain.}
}
\description{
Fits a Bayesian regression model for interval censored data. 
Can fit a proportional hazards, proportional odds or accelerated failure time model.
}
\details{
Currently supported distributions choices are "exponential", "weibull", "gamma", 
"lnorm", "loglogistic" and "generalgamma" (i.e. generalized gamma distribution). 

The \code{logPriorFxn} should take in the a vector of values corresponding to \emph{all}
the parameters of the model (baseline parameters first, regression parameters second) and returns the
log prior, calculated up to an additive constant. Default behavior is to use a flat prior. 
See examples for an example of using the log prior function.

Sampling is done by a single MH block updater on all the parameters. 
See \code{?bayesControls} for more details. 

Response variable should either be of the form \code{cbind(l, u)} or \code{Surv(l, u, type = 'interval2')}, 
where \code{l} and \code{u} are the lower and upper ends of the interval known to contain the event of interest. 
Uncensored data can be included by setting \code{l == u}, right censored data can be included by setting 
\code{u == Inf} or \code{u == NA} and left censored data can be included by setting \code{l == 0}.

Does not allow uncensored data points at t = 0 (i.e. \code{l == u == 0}), as this will 
lead to a degenerate estimator for most parametric families. Unlike the current implementation 
of survival's \code{survreg}, does allow left side of intervals of positive length to 0 and 
right side to be \code{Inf}. 

In regards to weights, they are not standardized. This means that if weight[i] = 2, 
this is the equivalent to having two observations with the same values as subject i. 


For numeric stability, if abs(right - left) < 10^-6, observation are considered 
uncensored rather than interval censored with an extremely small interval.
}
\examples{
data(miceData)

flat_prior_model <- ic_bayes(cbind(l, u) ~ grp, data = miceData)
# Default behavior is flat prior

priorFxn <- function(pars){
 ans <- 0
 ans <- ans + dnorm(pars[1], log = TRUE)
 ans <- ans + dnorm(pars[3], sd = 0.25, log = TRUE)
}
# Prior function puts N(0,1) prior on baseline shape parameter (first parameter)
# flat prior on baseline scale parameter (second parameter)
# and N(0,0.25) on regression parameter (third parameter)

inform_prior_fit <- ic_bayes(cbind(l, u) ~ grp, 
                             data = miceData,
                             logPriorFxn = priorFxn)

summary(flat_prior_model)
summary(inform_prior_fit)
# Note tight prior on the regression pulls posterior mean toward 0

}
\author{
Clifford Anderson-Bergman
}
