\name{midar}
\alias{midar}
\title{
Customize the Individual Diversity-Area Relationship Function
}
\description{
A wrapper to develop new Individual Diversity-Area Relationship functions on the fly.
}
\usage{
midar(mippp, mippp.sp = NULL, mimark = NULL, namesmark = NULL, traits = NULL,
tree = NULL, r = NULL, buffer = 0, bfw = NULL, what = NULL)
}

\arguments{
 \item{mippp}{A multitype (a.k.a. multivariate) marked point pattern. An object with the \link[spatstat]{ppp} format of \pkg{spatstat}.}
  \item{mippp.sp}{Univariate point pattern of the focal species. An object with the \link[spatstat]{ppp} format of \pkg{spatstat}.}
  \item{mimark}{Character. Name of the focal species in the multitype \code{mippp}.}
  \item{namesmark}{Character. If the marks in \code{mippp} are within a \code{data.frame}, the name of the column with the species names}
  \item{buffer}{One of "adapt", i.e., compute an adaptive buffer, or a number indicating the width of a fixed buffer area around the plot border}
  \item{bfw}{An \link[spatstat]{owin} object indicating the limits of the buffer area.}
  \item{r}{Vector of distances to compute IDAR(r) functions}
  \item{tree}{A phylogenetic tree in \code{phylo} format (\pkg{ape}) or a phylogenetic covariance matrix}
  \item{traits}{A \link[base]{data.frame} of traits, or a distance matrix among species (in \code{\link[stats]{dist}} or \code{\link[base]{matrix}} format) computed on a data.frame of traits.}
  \item{what}{A valid R expression or function that would accept a community matrix (sites x species) and return a unique value}
}
\details{
\code{midar} allows computing new \emph{IDAR}(\emph{r}) functions. The basis of all idar functions are the local communities defined around each point (e.g., each tree) of a focal species (\code{mimark}) for a certain circular neighborhood of radius \emph{r}. Some diversity measure is computed on each community an the average of all of them is returned as the idar value for this \emph{r}, i.e., as \emph{IDAR}(\emph{r}). The function \code{midar} applies the R function or expression defined by the argument \code{what} to each of the  "community data tables" (matrices) generated by \code{\link{mitable}} (one for each \emph{r} interval defined by the argument \code{r}) and return the result as a spatial summary function like all the others in the \pkg{idar} package (e.g., \code{\link{isar}} or \code{\link{pisar}}). The R expression or function should accept a community matrix (sites x species) as input and return a unique numeric value.
}
\value{
  \code{midar} return an object of class \code{fv}, see  \link[spatstat]{fv.object}, which can be plotted directly using  \link[spatstat]{plot.fv}. 
Essentially, a data frame containing a column named \emph{r} with the vector of values of the argument r at which the proposed function had been estimated and  another column, named \emph{"midar"} which  contains an estimate of the selected function.
}
\section{Simulation envelopes}{
To compute simulation envelopes for  \code{midar}  functions,  use \code{\link[spatstat]{envelope}}. See the examples in this help page and in \code{\link[idar]{multifocalsimulator}} to know how to compute simulation envelopes from appropriate null models.
}
\author{ Marcelino de la Cruz \email{marcelino.delacruz@urjc.es}}

\seealso{
\code{\link{isar}} or \code{\link{pisar}} in this package.
}
\examples{

data(SF)
data(SFphylotree)
 # Discard the size mark and keep the species mark in SF ppp:
  sfsp<- ppp(SF$x, SF$y, window=SF$window, marks=SF$marks$species)

# compute "individual Simpsom diversity-area relationship" around sp_44
# using function diversity from package vegan
require(vegan)
simpsom_sp_44<- midar(sfsp, mimark="sp_44", what =function(x) mean(diversity(x, "simpson")),
                                  r=1:15)


# test "individual Simpsom diversity-area relationship" against an inhomogeneous Poisson
# null modellfor sp_44. 
  # estimate intensityh surface for sp_44
   lambda<- density.ppp(unmark(sfsp[sfsp$marks=="sp_44"]), positive=TRUE)
  
  # generate 19 realizations of the null model, keeping all the other species fixed in their
  #  original coordinates.
   simulados<- multifocalsimulator(sfsp, mimark="sp_44", simulate=expression(rpoispp(lambda)),
                      nsim=19, nmin=15)

  # for simplicity define the function that we want to apply to each "local community"
  #  around each tree of sp_44
  mean_simpsom <- function(x) mean(diversity(x, "simpson"))

  # compute envelopes and plot them.
  simpsom_sp_44.env<-envelope(sfsp, midar, mimark="sp_44", what =mean_simpsom ,r=1:15,
                      nsim=19, simulate=simulados)
  plot(simpsom_sp_44.env)


# compute IPSVAR(r) "by hand"
   # first, check tree as would check it ipsvar
   arbol <- checktree(SFphylotree,  SF, "ipsvar", correct.phylo="exclude")

    # define function to obtain the averge psv from the set of local communities
    #  at each neigborhood radii r
     mipsv <- expression(mean(psv(x, tree=tree, compute.var=FALSE)$PSVs, na.rm=TRUE))
     # compute ipsvar "by hand" 
     sp_44_psv<- midar(sfsp, mimark="sp_44", tree=arbol, what =mipsv ,r=1:15)
     plot(sp_44_psv)

# compare it with the result of the built-in function
     plot(ipsvar(sfsp, mimark="sp_44", tree=arbol, r=1:15), add=TRUE, col="blue")
    
}

\keyword{ spatial }

