% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotter.R
\name{plot_cv_lasso}
\alias{plot_cv_lasso}
\title{Plot a cross validation error path}
\usage{
plot_cv_lasso(cv_fit, ...)
}
\arguments{
\item{cv_fit}{cross validated IILasso model}

\item{...}{parameters of}
}
\description{
Plot a cross validation error path
}
\examples{
X <- matrix(c(1,2,3,5,4,7,6,8,9,10), nrow=5, ncol=2)
b <- matrix(c(-1,1), nrow=2, ncol=1)
e <- matrix(c(0,-0.1,0.1,-0.1,0.1), nrow=5, ncol=1)
y <- as.numeric(X \%*\% b + e)
cv_fit <- cv_lasso(X, y, nfolds=5)
fit <- cv_fit$fit
pr <- predict_lasso(fit, X, cv_fit$lambda.min)
plot_cv_lasso(cv_fit)
}
