% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{count_frames}
\alias{count_frames}
\alias{frames_count}
\title{Count the number of frames in a TIFF file.}
\usage{
count_frames(path)

frames_count(path)
}
\arguments{
\item{path}{A string. The path to the tiff file to read.}
}
\value{
A number, the number of frames in the TIFF file. This has an
attribute \code{n_dirs} which holds the true number of directories in the TIFF
file, making no allowance for the way ImageJ may write TIFF files.
}
\description{
TIFF files can hold many frames. Often this is sensible, e.g. each frame
could be a time-point in a video or a slice of a z-stack.
}
\details{
For those familiar with TIFF files, this function counts the number of
directories in a TIFF file. There is an adjustment made for some
ImageJ-written TIFF files.
}
\examples{
count_frames(system.file("img", "Rlogo.tif", package = "ijtiff"))
}
