% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vanvliet}
\alias{vanvliet}
\title{Young-Van Vliet recursive Gaussian filter.}
\usage{
vanvliet(im, sigma, order = 0L, axis = "x", boundary_conditions = 0L)
}
\arguments{
\item{im}{an image}

\item{sigma}{standard deviation of the Gaussian filter}

\item{order}{the order of the filter 0,1,2,3}

\item{axis}{Axis along which the filter is computed. Can be <tt>{ 'x' | 'y' | 'z' | 'c' }</tt>.}

\item{boundary_conditions}{Boundary conditions. Can be <tt>{ 0=dirichlet | 1=neumann }</tt>.
(Dirichlet boundary condition has a strange behavior)}
}
\description{
From: I.T. Young, L.J. van Vliet, M. van Ginkel, Recursive Gabor filtering.
      IEEE Trans. Sig. Proc., vol. 50, pp. 2799-2805, 2002.
      (this is an improvement over Young-Van Vliet, Sig. Proc. 44, 1995)
}
\details{
Boundary conditions (only for order 0) using Triggs matrix, from
      B. Triggs and M. Sdika. Boundary conditions for Young-van Vliet
      recursive filtering. IEEE Trans. Signal Processing,
      vol. 54, pp. 2365-2367, 2006.
}
\examples{
vanvliet(boats,sigma=2,order=0) \%>\% plot("Zeroth-order Young-van Vliet along x")
vanvliet(boats,sigma=2,order=1) \%>\% plot("First-order Young-van Vliet along x")
vanvliet(boats,sigma=2,order=1) \%>\% plot("Second-order Young-van Vliet along x")
vanvliet(boats,sigma=2,order=1,axis="y") \%>\% plot("Second-order Young-van Vliet along y")
}

