% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racog.R
\name{wracog}
\alias{wracog}
\title{Wrapper for rapidly converging Gibbs algorithm.}
\usage{
wracog(train, validation, wrapper, slideWin = 10, threshold = 0.02,
  classAttr = "Class", ...)
}
\arguments{
\item{train}{\code{data.frame}. A initial dataset to generate first model.
All columns, except \code{classAttr} one, have to be numeric or coercible
to numeric.}

\item{validation}{\code{data.frame}. A dataset to compare results of
consecutive classifiers. Must have the same structure of \code{train}.}

\item{wrapper}{An \code{S3} object. There must exist a method
\code{\link{trainWrapper}} implemented for the class of the object, and a
\code{\link[stats]{predict}} method implemented for the class of the model
returned by \code{trainWrapper}.}

\item{slideWin}{Number of last sensitivities to take into account to meet the
stopping criteria. By default, 10.}

\item{threshold}{Threshold that the last \code{slideWin} sensitivities mean
should reach. By default, 0.02.}

\item{classAttr}{\code{character}. Indicates the class attribute from
\code{train} and \code{validation}. Must exist in them.}

\item{...}{further arguments for \code{wrapper}.}
}
\value{
A \code{data.frame} with the same structure as \code{train},
  containing the generated synthetic examples.
}
\description{
Generates synthetic minority examples by approximating their probability
distribution until sensitivity of \code{wrapper} over \code{validation}
cannot be further improved. Works only on discrete numeric datasets.
}
\details{
Until the last \code{slideWin} executions of \code{wrapper} over
\code{validation} dataset reach a mean sensitivity lower than
\code{threshold}, the algorithm keeps generating samples using Gibbs Sampler,
and adding misclassified samples with respect to a model generated by a
former train, to the train dataset. Initial model is built on initial
\code{train}.
}
\examples{
data(haberman)
myWrapper <- structure(list(), class="C50Wrapper")
trainWrapper.C50Wrapper <- function(wrapper, train, trainClass){
  C50::C5.0(train, trainClass)
}

trainFold <- sample(1:nrow(haberman), nrow(haberman)/2, FALSE)
newSamples <- wracog(haberman[trainFold, ], haberman[-trainFold, ],
                     myWrapper, classAttr = "Class")

}
\references{
Das, Barnan; Krishnan, Narayanan C.; Cook, Diane J. Racog and Wracog: Two
Probabilistic Oversampling Techniques. IEEE Transactions on Knowledge and
Data Engineering 27(2015), Nr. 1, p. 222–234.
}
