% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Add_parameters.R
\name{add_parameters}
\alias{add_parameters}
\title{Calculate relevant data from REE}
\usage{
add_parameters(data, prefix = NULL, suffix = NULL)
}
\arguments{
\item{data}{A dataframe}

\item{prefix}{A prefix in your columns e.g. ICP_La}

\item{suffix}{A suffix in your columns e.g. La_ppm}
}
\value{
A dataframe
}
\description{
Calculate the Eu and Ce anomalies, the sum or REE + Y and P as molar ratios from imputed data. It expects the result of data \%>\% model_ree() \%>\%  impute_ree()
}
\examples{

testing_data \%>\%
dplyr::slice(12) \%>\%
model_REE(prefix = 'Zr_', suffix = '_ppm') \%>\%
impute_REE(prefix = 'Zr_', suffix = '_ppm')  \%>\%
add_parameters(prefix = 'Zr_', suffix = '_ppm')


}
