% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.missing.R
\name{vis.missing}
\alias{vis.missing}
\title{Visualize distribution of Missing Values}
\usage{
vis.missing(ts.withNA, na.identifier = NA, xlab = "", ylab = "", ...)
}
\arguments{
\item{ts.withNA}{Time Series (\code{\link{ts}}) object with NAs}

\item{na.identifier}{Missing Value Identifier. 
If another value than NA indicates missing values this can be specified here. 
Identifier can be a character string as well as a numeric value.}

\item{xlab}{Label for x axis of the plot}

\item{ylab}{Label for y axis of plot}

\item{...}{Additional graphical parameters like e.g. main}
}
\description{
Visualize the distribution of missing values within a time series.
}
\examples{
#Load dataset
require(datasets)
data(AirPassengers)

#Create dataset with NAs
airp.na <- AirPassengers
airp.na[c(3:5,44,77,99:103)] <- NA

#Visualize the missing values in this time series
vis.missing(airp.na)

}
\author{
Steffen Moritz
}

