% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_case.R
\name{in_case}
\alias{in_case}
\title{A pipe-friendly general vectorized if}
\usage{
in_case(..., preserve = FALSE, default = NA)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> A sequence of two-sided
formulas.
The left hand side (LHS) determines which values match this case.
The right hand side (RHS) provides the replacement value.

The LHS must evaluate to a logical vector.

Both LHS and RHS may have the same length of either 1 or \code{n}.
The value of \code{n} must be consistent across all cases.
The case of \code{n == 0} is treated as a variant of \code{n != 1}.

\code{NULL} inputs are ignored.}

\item{preserve}{If \code{TRUE}, unmatched elements of the input will be
returned unmodified.
(The elements may have their type coerced to be compatible with
replacement values.)
If \code{FALSE}, unmatched elements of the input will be replaced
with \code{default}.
Defaults to \code{FALSE}.}

\item{default}{If \code{preserve} is \code{FALSE}, a value to replace unmatched
elements of the input.
Defaults to \code{NA}.}
}
\value{
A vector of length 1 or n, matching the length of the logical input
or output vectors.
Inconsistent lengths will generate an error.
}
\description{
This function allows you to vectorize multiple if_else() statements.
If no cases match, NA is returned.
This function derived from \code{\link[dplyr:case_when]{dplyr::case_when()}}.
Unlike \code{\link[dplyr:case_when]{dplyr::case_when()}}, \code{in_case()} supports piping elegantly and
attempts to handle inconsistent types (see examples).
}
\examples{
# Non-piped statements are handled the same as dplyr::case_when()
x <- 1:30
in_case(
  x \%\% 15 == 0 ~ "fizz buzz",
  x \%\%  3 == 0 ~ "fizz",
  x \%\%  5 == 0 ~ "buzz",
  TRUE         ~ x
)

# A vector can be directly piped into in_case() without error
1:30 \%>\%
  in_case(
    . \%\% 15 == 0 ~ "fizz buzz",
    . \%\%  3 == 0 ~ "fizz",
    . \%\%  5 == 0 ~ "buzz",
    TRUE         ~ .
  )

# in_case() silently converts types
1:30 \%>\%
  in_case(
    . \%\% 15 == 0 ~ 35,
    . \%\%  3 == 0 ~ 5,
    . \%\%  5 == 0 ~ 7,
    TRUE         ~ NA
  )

x <- 1:30
try(
  dplyr::case_when(
    x \%\% 15 == 0 ~ 35,
    x \%\%  3 == 0 ~ 5,
    x \%\%  5 == 0 ~ 7,
    TRUE         ~ NA
  )
)

# default and preserve make it easier to handle unmatched values
1:30 \%>\%
  in_case(
    . \%\% 15 == 0 ~ "fizz buzz",
    . \%\%  3 == 0 ~ "fizz",
    . \%\%  5 == 0 ~ "buzz",
    default      = "pass"
  )

1:30 \%>\%
  in_case(
    . \%\% 15 == 0 ~ "fizz buzz",
    . \%\%  3 == 0 ~ "fizz",
    . \%\%  5 == 0 ~ "buzz",
    preserve     = TRUE
  )
}
\seealso{
\code{\link[=in_case_fct]{in_case_fct()}} to return a factor and
\code{\link[=in_case_list]{in_case_list()}} to return a list

\code{\link[=switch_case]{switch_case()}} a simpler alternative for when each case involves
\code{\link{==}} or \code{\link{\%in\%}}

\code{\link[=fn_case]{fn_case()}}, a simpler alternative for when each case uses the
same function

\code{\link[=if_case]{if_case()}}, a pipeable alternative to \code{\link[dplyr:if_else]{dplyr::if_else()}}

\code{\link[dplyr:case_when]{dplyr::case_when()}}, from which this function is derived
}
