% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap incidence time series}
\usage{
bootstrap(x, randomise_groups = FALSE)
}
\arguments{
\item{x}{An \code{incidence} object.}

\item{randomise_groups}{A \code{logical} indicating whether groups should be
randomised as well in the resampling procedure; respective group sizes will
be preserved, but this can be used to remove any group-specific temporal
dynamics. If \code{FALSE} (default), data are resampled within groups.}
}
\value{
An \code{incidence} object.
}
\description{
This function can be used to bootstrap \code{incidence} objects. Bootstrapping is
done by sampling with replacement the original input dates. See \code{details} for
more information on how this is implemented.
}
\details{
As original data are not stored in \code{incidence} objects, the
bootstrapping is achieved by multinomial sampling of date bins weighted by
their relative incidence.
}
\examples{

if (require(outbreaks) && require(ggplot2)) { withAutoprint({
  i <- incidence(fluH7N9_china_2013$date_of_onset)
  i
  plot(i)

  ## one simple bootstrap
  x <- bootstrap(i)
  x
  plot(x)

})}

}
\seealso{
\link[incidence:find_peak]{incidence::find_peak} to use estimate peak date using bootstrap
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
