% Generated by roxygen2 (4.0.2): do not edit by hand
\name{language}
\alias{language}
\title{Detects language of the text}
\usage{
language(text, local.api = FALSE)
}
\arguments{
\item{text}{text for analysis}

\item{local.api}{logical, whether use local or remote API}
}
\value{
List with language probability pairs
}
\description{
Given input text, returns a probability distribution over 33 possible
languages of what language the text was written in.
}
\examples{
languages <- language("Monday: Delightful with mostly sunny skies.
                            Highs in the low 70s.")
languages
most.possible <- sort(unlist(languages), decreasing = TRUE)[1:2]
cat(sprintf("Detected \%s language with probability \%0.4f.\\n",
            names(most.possible)[1], most.possible[1]))
cat(sprintf("Next possible is \%s with probability \%0.4f.",
            names(most.possible)[2], most.possible[2]))
}
\seealso{
\code{\link{political}}, \code{\link{sentiment}}
}
\keyword{API}
\keyword{detection}
\keyword{indico.io}
\keyword{language}
\keyword{learning}
\keyword{machine}

