% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer_variable.R
\name{IntegerVariable}
\alias{IntegerVariable}
\title{IntegerVariable Class}
\description{
Represents a integer valued variable for an individual.
This class is similar to \code{\link[individual]{CategoricalVariable}},
but can be used for variables with unbounded ranges, or other situations where part
of an individual's state is better represented by an integer, such as
household or age bin.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IntegerVariable-new}{\code{IntegerVariable$new()}}
\item \href{#method-IntegerVariable-get_values}{\code{IntegerVariable$get_values()}}
\item \href{#method-IntegerVariable-get_index_of}{\code{IntegerVariable$get_index_of()}}
\item \href{#method-IntegerVariable-get_size_of}{\code{IntegerVariable$get_size_of()}}
\item \href{#method-IntegerVariable-queue_update}{\code{IntegerVariable$queue_update()}}
\item \href{#method-IntegerVariable-queue_extend}{\code{IntegerVariable$queue_extend()}}
\item \href{#method-IntegerVariable-queue_shrink}{\code{IntegerVariable$queue_shrink()}}
\item \href{#method-IntegerVariable-size}{\code{IntegerVariable$size()}}
\item \href{#method-IntegerVariable-.update}{\code{IntegerVariable$.update()}}
\item \href{#method-IntegerVariable-.resize}{\code{IntegerVariable$.resize()}}
\item \href{#method-IntegerVariable-clone}{\code{IntegerVariable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-new"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-new}{}}}
\subsection{Method \code{new()}}{
Create a new IntegerVariable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$new(initial_values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{initial_values}}{a vector of the initial values for each individual}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-get_values"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-get_values}{}}}
\subsection{Method \code{get_values()}}{
Get the variable values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$get_values(index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{optionally return a subset of the variable vector. If
\code{NULL}, return all values; if passed a \code{\link[individual]{Bitset}}
or integer vector, return values of those individuals.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-get_index_of"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-get_index_of}{}}}
\subsection{Method \code{get_index_of()}}{
Return a \code{\link[individual]{Bitset}} for individuals with some subset of values.
Either search for indices corresponding to values in \code{set}, or
for indices corresponding to values in range \eqn{[a,b]}. Either \code{set}
or \code{a} and \code{b} must be provided as arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$get_index_of(set = NULL, a = NULL, b = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set}}{a vector of values (providing \code{set} means \code{a,b} are ignored)}

\item{\code{a}}{lower bound}

\item{\code{b}}{upper bound}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-get_size_of"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-get_size_of}{}}}
\subsection{Method \code{get_size_of()}}{
Return the number of individuals with some subset of values.
Either search for indices corresponding to values in \code{set}, or
for indices corresponding to values in range \eqn{[a,b]}. Either \code{set}
or \code{a} and \code{b} must be provided as arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$get_size_of(set = NULL, a = NULL, b = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set}}{a vector of values (providing \code{set} means \code{a,b} are ignored)}

\item{\code{a}}{lower bound}

\item{\code{b}}{upper bound}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-queue_update"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-queue_update}{}}}
\subsection{Method \code{queue_update()}}{
Queue an update for a variable. There are 4 types of variable update:

\enumerate{
 \item{Subset update: }{The argument \code{index} represents a subset of the variable to
update. The argument \code{values} should be a vector whose length matches the size of \code{index},
which represents the new values for that subset.}
 \item{Subset fill: }{The argument \code{index} represents a subset of the variable to
update. The argument \code{values} should be a single number, which fills the specified subset.}
 \item{Variable reset: }{The index vector is set to \code{NULL} and the argument \code{values}
replaces all of the current values in the simulation. \code{values} should be a vector
whose length should match the size of the population, which fills all the variable values in
the population}
 \item{Variable fill: }{The index vector is set to \code{NULL} and the argument \code{values}
should be a single number, which fills all of the variable values in
the population.}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$queue_update(values, index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{a vector or scalar of values to assign at the index}

\item{\code{index}}{is the index at which to apply the change, use \code{NULL} for the
fill options. If using indices, this may be either a vector of integers or
a \code{\link[individual]{Bitset}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-queue_extend"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-queue_extend}{}}}
\subsection{Method \code{queue_extend()}}{
extend the variable with new values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$queue_extend(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{to add to the variable}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-queue_shrink"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-queue_shrink}{}}}
\subsection{Method \code{queue_shrink()}}{
shrink the variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$queue_shrink(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{a bitset or vector representing the individuals to remove}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-size"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-size}{}}}
\subsection{Method \code{size()}}{
get the size of the variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$size()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-.update"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-.update}{}}}
\subsection{Method \code{.update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$.update()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-.resize"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-.resize}{}}}
\subsection{Method \code{.resize()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$.resize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IntegerVariable-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IntegerVariable-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IntegerVariable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
