% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_weight_distribution}
\alias{plot_weight_distribution}
\title{Plot weight distribution}
\usage{
plot_weight_distribution(
  network_table,
  binwidth = 0.01,
  show_border = FALSE,
  border_color = "black",
  alpha = 1,
  theme = "viridis",
  theme_begin = 0,
  theme_end = 0.5,
  theme_direction = -1,
  legend_position = "right"
)
}
\arguments{
\item{network_table}{The weight data table of network.}

\item{binwidth}{Width of the bins.}

\item{show_border}{Logical value, whether to show border of the bins.}

\item{border_color}{Color of the border.}

\item{alpha}{Alpha value of the bins.}

\item{theme}{Theme of the bins.}

\item{theme_begin}{Begin value of the theme.}

\item{theme_end}{End value of the theme.}

\item{theme_direction}{Direction of the theme.}

\item{legend_position}{The position of legend.}
}
\value{
ggplot object
}
\description{
Plot weight distribution
}
\examples{
data("example_matrix")
network_table <- inferCSN(example_matrix)
plot_weight_distribution(network_table)
}
