% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{exir}
\alias{exir}
\alias{ExIR}
\title{Experimental data-based Integrated Ranking}
\usage{
exir(
  Desired_list = NULL,
  Diff_data,
  Diff_value,
  Regr_value = NULL,
  Sig_value,
  Exptl_data,
  Condition_colname,
  Normalize = FALSE,
  r = 0,
  alpha = 0.05,
  num_trees = 10000,
  num_permutations = 100,
  seed = 1234,
  verbose = TRUE
)
}
\arguments{
\item{Desired_list}{(Optional) A character vector of your desired features. This vector could be, for
instance, a list of features obtained from cluster analysis, time-course analysis,
or a list of dysregulated features with a specific sign.}

\item{Diff_data}{A dataframe of all significant differential/regression data and their
statistical significance values (p-value/adjusted p-value).
You may have selected a proportion of the differential data as the significant ones according
to your desired thresholds. A function, named diff_data.assembly, has also been
provided for the convenient assembling of the Diff_data dataframe.}

\item{Diff_value}{A numeric vector containing the column number(s) of the differential
data in the Diff_data dataframe. The differential data could result from any type of
differential data analysis. One example could be the fold changes (FCs) obtained from differential
expression analyses. The user may provide as many differential data as he/she wish.}

\item{Regr_value}{(Optional) A numeric vector containing the column number(s) of the regression
data in the Diff_data dataframe. The regression data could result from any type of regression
data analysis or other analyses such as time-course data analyses that are based on regression models.}

\item{Sig_value}{A numeric vector containing the column number(s) of the significance values (p-value/adjusted p-value) of
both differential and regression data (if provided). Providing significance values for the regression data is optional.}

\item{Exptl_data}{A dataframe containing all of the experimental including a column for specifying the conditions.
The features/variables of the dataframe should be as the columns and the samples should come in the rows.
The condition column should be of the character class. For example, if the study includes several replicates of
cancer and normal samples, the condition column should include "cancer" and "normal" as the conditions of different samples.
Also, the prior normalization of the experimental data is highly recommended. Otherwise,
the user may set the Normalize argument to TRUE for a simple log2 transformation of the data.
The experimental data could come from a variety sources such as transcriptomics and proteomics assays.}

\item{Condition_colname}{A string or character vector specifying the name of the condition column of the Exptl_data dataframe.}

\item{Normalize}{Logical; whether the experimental data should be normalized or not (default is FALSE). If TRUE, the
experimental data will be log2 transformed.}

\item{r}{The threshold of Pearson correlation coefficient for the selection of correlated features (default is 0).}

\item{alpha}{The threshold of the statistical significance (p-value) used throughout the entir model (default is 0.05)}

\item{num_trees}{Number of trees to be used for the random forest classification (supervised machine learning) Default is set to 10000.}

\item{num_permutations}{Number of permutations to be used for computation of the statistical significances (p-values) of
the importance scores resulted from random forest classification (default is 100).}

\item{seed}{The seed to be used for all of the random processes throughout the model (default is 1234).}

\item{verbose}{Logical; whether the accomplishment of different stages of the model should be printed (default is TRUE).}
}
\value{
A list of one to four tables including:

- Driver table: Top candidate drivers

- DE-mediator table: Top candidate differentially expressed/abundant mediators

- nonDE-mediators table: Top candidate non-differentially expressed/abundant mediators

- Biomarker table: Top candidate biomarkers

The number of returned tables depends on the input data and specified arguments.
}
\description{
This function runs the Experimental data-based Integrated Ranking (ExIR)
model for the classification and ranking of top candidate features. The input
data could come from any type of experiment such as transcriptomics and proteomics.
}
\seealso{
\code{\link[influential]{diff_data.assembly}},
\code{\link[influential]{ivi}},
\code{\link[coop]{pcor}},
\code{\link[stats]{prcomp}},
\code{\link[ranger]{ranger}},
\code{\link[ranger]{importance_pvalues}}

Other integrative ranking functions: 
\code{\link{hubness.score}()},
\code{\link{ivi.from.indices}()},
\code{\link{ivi}()},
\code{\link{spreading.score}()}
}
\concept{integrative ranking functions}
\keyword{exir}
