% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidatos.R
\name{candidatos}
\alias{candidatos}
\title{Download candidate data}
\usage{
candidatos(tipo_eleccion, anno, mes, nivel)
}
\arguments{
\item{tipo_eleccion}{The type of choice you want to download. The accepted values are "congreso", "senado", "europeas" o "municipales".}

\item{anno}{The year of the election in YYYY format.}

\item{mes}{The month of the election in MM format.}

\item{nivel}{The administrative level for which the data is wanted ("mesa" for polling stations or "municipio" for municipalities). Only necessary when tipo_eleccion = "senado"}
}
\value{
data.frame with the candidates data. If tipo_eleccion = "senado" a column called  `votos` is included with the votes recieved by each candidate. If other type of election is selected this column is not included since the votes are not received by the specific candidates but by the closed list of the party.
}
\description{
`candidatos()` downloads, formats and imports to the environment the data of the candidates from the electoral lists of the selected elections.
}
\examples{
data <- candidatos(tipo_eleccion = "senado", anno = "2004",
                   mes = "03", nivel = "municipio")
str(data)

}
