% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggreagate_profiles.R
\name{aggregate_profiles}
\alias{aggregate_profiles}
\title{Aggregate Ceteris Paribus Profiles}
\usage{
aggregate_profiles(x, ..., only_numerical = TRUE, groups = NULL,
  type = "partial", variables = NULL)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function `ceteris_paribus()`}

\item{...}{other explainers that shall be plotted together}

\item{only_numerical}{a logical. If TRUE then only numerical variables will be plotted. If FALSE then only categorical variables will be plotted.}

\item{groups}{a variable name that will be usef for grouping. By default 'NULL' which means that no groups shall be calculated}

\item{type}{either 'partial'/'conditional'/'accumulated' for parital dependence, conditional profiles of accumulated local effects}

\item{variables}{if not NULL then only `variables` will be presented}
}
\value{
an 'aggregated_profiles_explainer' layer
}
\description{
The function 'aggregate_profiles' calculates an aggregate of ceteris paribus profiles.
It can be: Partial Dependency Profile (average across Ceteris Paribus Profiles),
Conditional Dependency Profile (local weighted average across Ceteris Paribus Profiles) or
Accumulated Local Dependency Profile (cummulated average local changes in Ceteris Paribus Profiles).
}
\examples{
library("DALEX")
 \donttest{
library("randomForest")
 model_titanic_rf <- randomForest(survived ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)
 model_titanic_rf

 explain_titanic_rf <- explain(model_titanic_rf,
                           data = titanic[,-9],
                           y = titanic$survived)

selected_passangers <- select_sample(titanic, n = 100)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
head(cp_rf)

pdp_rf_p <- aggregate_profiles(cp_rf, variables = "age", type = "partial")
pdp_rf_p$`_label_` <- "RF_partial"
pdp_rf_c <- aggregate_profiles(cp_rf, variables = "age", type = "conditional")
pdp_rf_c$`_label_` <- "RF_conditional"
pdp_rf_a <- aggregate_profiles(cp_rf, variables = "age", type = "accumulated")
pdp_rf_a$`_label_` <- "RF_accumulated"
plot(pdp_rf_p, pdp_rf_c, pdp_rf_a, color = "_label_")

pdp_rf <- aggregate_profiles(cp_rf, variables = "age",
                             groups = "gender")
head(pdp_rf)
plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red") +
  show_aggregated_profiles(pdp_rf, size = 3, color = "_label_")
}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
