% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_importance.R
\name{feature_importance}
\alias{feature_importance}
\alias{feature_importance.explainer}
\alias{feature_importance.default}
\title{Feature Importance}
\usage{
feature_importance(x, ...)

\method{feature_importance}{explainer}(x,
  loss_function = loss_root_mean_square, ..., type = c("raw", "ratio",
  "difference"), n_sample = NULL, B = 1,
  keep_raw_permutations = NULL, variables = NULL,
  variable_groups = NULL, label = NULL)

\method{feature_importance}{default}(x, data, y,
  predict_function = predict, loss_function = loss_root_mean_square,
  ..., label = class(x)[1], type = c("raw", "ratio", "difference"),
  n_sample = NULL, B = 1, keep_raw_permutations = NULL,
  variables = NULL, variable_groups = NULL)
}
\arguments{
\item{x}{an explainer created with function \code{DALEX::explain()}, or a model to be explained.}

\item{...}{other parameters}

\item{loss_function}{a function thet will be used to assess variable importance}

\item{type}{character, type of transformation that should be applied for dropout loss.
"raw" results raw drop lossess, "ratio" returns \code{drop_loss/drop_loss_full_model}
while "difference" returns \code{drop_loss - drop_loss_full_model}}

\item{n_sample}{number of observations that should be sampled for calculation of variable importance.
If \code{NULL} then variable importance will be calculated on whole dataset (no sampling).}

\item{B}{integer, number of permutation rounds to perform on each variable}

\item{keep_raw_permutations}{logical or \code{NULL}, determines if output retains information for individual permutations;
default is to omit for \code{B=1} and keep otherwise}

\item{variables}{vector of variables. If \code{NULL} then variable importance will be tested for each variable from the \code{data} separately. By default \code{NULL}}

\item{variable_groups}{list of variables names vectors. This is for testing joint variable importance.
If \code{NULL} then variable importance will be tested separately for \code{variables}.
By default \code{NULL}. If specified then it will override \code{variables}}

\item{label}{name of the model. By default it's extracted from the \code{class} attribute of the model}

\item{data}{validation dataset, will be extracted from \code{x} if it's an explainer
NOTE: It is best when target variable is not present in the \code{data}}

\item{y}{true labels for \code{data}, will be extracted from \code{x} if it's an explainer}

\item{predict_function}{predict function, will be extracted from \code{x} if it's an explainer}
}
\value{
an object of the class \code{feature_importance}
}
\description{
This function calculates permutation based feature importance.
For this reason it is also called the Variable Dropout Plot.
}
\details{
Find more detailes in the \href{https://pbiecek.github.io/PM_VEE/featureImportance.html}{Feature Importance Chapter}.
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8])

fi_glm <- feature_importance(explain_titanic_glm)
plot(fi_glm)

fi_glm_joint1 <- feature_importance(explain_titanic_glm,
                   variable_groups = list("demographics" = c("gender", "age"),
                   "ticket_type" = c("fare")),
                   label = "lm 2 groups")

plot(fi_glm_joint1)

fi_glm_joint2 <- feature_importance(explain_titanic_glm,
                   variable_groups = list("demographics" = c("gender", "age"),
                                          "wealth" = c("fare", "class"),
                                          "family" = c("sibsp", "parch"),
                                          "embarked" = "embarked"),
                   label = "lm 5 groups")

plot(fi_glm_joint2, fi_glm_joint1)

explain_titanic_glm

 \donttest{
library("randomForest")

model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8])

fi_rf <- feature_importance(explain_titanic_rf)
plot(fi_rf)

fi_rf <- feature_importance(explain_titanic_rf, B = 5) # 5 replications
plot(fi_rf)

fi_rf_group <- feature_importance(explain_titanic_rf,
                   variable_groups = list("demographics" = c("gender", "age"),
                   "wealth" = c("fare", "class"),
                   "family" = c("sibsp", "parch"),
                   "embarked" = "embarked"),
                   label = "rf 4 groups")

plot(fi_rf_group, fi_rf)

HR_rf_model <- randomForest(status ~., data = HR, ntree = 100)

explainer_rf  <- explain(HR_rf_model, data = HR, y = HR$status,
                         verbose = FALSE, precalculate = FALSE)

fi_rf <- feature_importance(explainer_rf, type = "raw",
                            loss_function = loss_cross_entropy)
head(fi_rf)
plot(fi_rf)

HR_glm_model <- glm(status == "fired"~., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR, y = HR$status == "fired")
fi_glm <- feature_importance(explainer_glm, type = "raw",
                             loss_function = loss_root_mean_square)
head(fi_glm)
plot(fi_glm)

library("xgboost")
model_martix_train <- model.matrix(status == "fired" ~ . -1, HR)
data_train <- xgb.DMatrix(model_martix_train, label = HR$status == "fired")
param <- list(max_depth = 2, eta = 1, silent = 1, nthread = 2,
              objective = "binary:logistic", eval_metric = "auc")
HR_xgb_model <- xgb.train(param, data_train, nrounds = 50)

explainer_xgb <- explain(HR_xgb_model, data = model_martix_train,
                         y = HR$status == "fired", label = "xgboost")

fi_xgb <- feature_importance(explainer_xgb, type = "raw")
head(fi_xgb)
plot(fi_xgb, fi_glm)
 }
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
