% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactionFilters.R
\name{transactionFilters}
\alias{transactionFilters}
\alias{transactionFilterNonderivative}
\alias{transactionFilterDerivative}
\alias{transactionFilterNonderivativeHoldings}
\alias{transactionFilterDerivativeHoldings}
\title{transactionFilters}
\usage{
transactionFilterNonderivative(
  filing,
  footnoteKeywords,
  issuerKeywords,
  issuerTradingSymbol,
  rptOwnerKeywords,
  transactionType
)

transactionFilterDerivative(
  filing,
  footnoteKeywords,
  issuerKeywords,
  issuerTradingSymbol,
  rptOwnerKeywords,
  transactionType
)

transactionFilterNonderivativeHoldings(
  filing,
  footnoteKeywords,
  issuerKeywords,
  issuerTradingSymbol,
  rptOwnerKeywords
)

transactionFilterDerivativeHoldings(
  filing,
  footnoteKeywords,
  issuerKeywords,
  issuerTradingSymbol,
  rptOwnerKeywords
)
}
\arguments{
\item{filing}{The object containing a single transaction from a Form 4
filing in text format}

\item{footnoteKeywords}{The character vector containing any specified key
words to be searched in the transaction's footnotes. Default is NA.}

\item{issuerKeywords}{The character vector containing any specified key
words to be searched within the issuer block. Default is NA.}

\item{issuerTradingSymbol}{The character vector containing any specified
stock tickers. Default is NA.}

\item{rptOwnerKeywords}{The character vector contianing any specified key
words to be searched within the rptOwner block. Default is NA.}

\item{transactionType}{The character vector containing any specified
transaction codes. Default is NA.}
}
\value{
An integer value that if greater than 0, reflects that at the one of
the criteria parameters listed above has been met. The form will then be
parsed further. Otherwise, if the integer value is 0, the function pulls in
the next Form 4 to evaluate.
}
\description{
transactionFilters
}
\note{
\code{transactionFilterNonderivative} parses a transaction contained
in the filing and returns an integer value greater than 0 if one of the
transaction specific key word criteras or form specific key word criteras
is met.This function is specifically for the
\code{\link{nonderivativeTransactionsScrape}} and
\code{\link{nonderivativeTransactionsPullAndScrape}} functions.

\code{transactionFilterDerivative} parses a transaction contained
in the filing and returns an integer value greater than 0 if the
transaction contains one of the specific key word criteras or if the
key word criteria cannot be applied at the transaction level (
rptOwnerKeywords or issuerKeywords for example), but the form contains
form specific key word critera. This function is specifically for the
\code{\link{derivativeTransactionsScrape}} and
\code{\link{derivativeTransactionsPullAndScrape}} functions. The function
shares the same paramters as
\code{\link{formFilterNonderivativeTransactions}} (filing,
footnoteKeywords, issuerKeywords, issuerTradingSymbol, rptOwnerKeywords,
transactionType). The only difference is within the parsing commands which
use the key word derivative rather than nonderivative.

\code{transactionFilterNonderivativeHoldings} parses a transaction
contained in the filing and returns an integer value greater than 0 if the
transaction contains one of the specific key word criteras or if the
key word criteria cannot be applied at the transaction level (
rptOwnerKeywords or issuerKeywords for example), but the form contains
form specific key word critera. This function is specifically for the
\code{\link{nonderivativeHoldingsScrape}} and
\code{\link{nonderivativeHoldingsPullAndScrape}} functions. The function
shares the same paramters as
\code{\link{transactionFilterNonderivative}} (filing,
footnoteKeywords, issuerKeywords, issuerTradingSymbol, rptOwnerKeywords)
except for transactionType since that isn't a criteria for a nonderivative
holdings. Additionally, parsing criteria is different due to targeting
holding information rather than transaction information.

\code{transactionFilterDerivativeHoldings} parses a transaction
contained in the filing and returns an integer value greater than 0 if the
transaction contains one of the specific key word criteras or if the
key word criteria cannot be applied at the transaction level (
rptOwnerKeywords or issuerKeywords for example), but the form contains
form specific key word critera. This function is specifically for the
\code{\link{derivativeHoldingsScrape}} and
\code{\link{derivativeHoldingsPullAndScrape}} functions. The function
shares the same paramters as
\code{\link{transactionFilterNonderivative}} (filing,
footnoteKeywords, issuerKeywords, issuerTradingSymbol, rptOwnerKeywords)
except for transactionType since that isn't a criteria for a derivative
holdings. The only difference is within the parsing commands which
use the key word derivative rather than nonderivative.
}
