% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivlm.R
\name{iv.lm}
\alias{iv.lm}
\title{Estimate linear regression models with an instrumental variable.}
\usage{
iv.lm(model_formula, instrument_formula = NULL, data = NULL, ...)
}
\arguments{
\item{model_formula}{The formula of the main regression problem.}

\item{instrument_formula}{The formula for the first stage of the regression problem.  Estimate an endogenous variable from one (or more) instruments.  If blank, defaults to ordinary linear regression.}

\item{data}{(optional) A data frame containing all variables for the regression model.}

\item{...}{Additional arguments to pass to glm().}
}
\description{
This function allows you to estimate a two-stage least squares linear regression in one step.
}
\examples{
# Fake data
N <- 1000
z <- rnorm(N, 1, 1)
error <- rnorm(N, 1, 1)
x <- z + error + rnorm(N, 1, 1)
y <- x + error

# Fit OLS
fit_ols <- lm(y ~ x)

# Fit 2SLS
fit_2sls <- iv.lm(y ~ x, x ~ z)

summary(fit_ols)
summary(fit_2sls)
}
\keyword{instrument}
