% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_1freq.R
\name{univariate_frequency}
\alias{univariate_frequency}
\title{Univariate claim frequency}
\usage{
univariate_frequency(df, x, nclaims, exposure, severity = NULL, premium = NULL)
}
\arguments{
\item{df}{data.frame with insurance portfolio}

\item{x}{column in \code{df} with risk factor}

\item{nclaims}{column in \code{df} with number of claims}

\item{exposure}{column in \code{df} with exposure}

\item{severity}{column in \code{df} with severity (default is NULL)}

\item{premium}{column in \code{df} with premium (default is NULL)}
}
\value{
An list of class \code{univ_freq} with components
\item{df}{data frame with claim frequency}
\item{xvar}{name of column in df with risk factor}
\item{nclaims}{name of column in df with number of claims}
\item{exposure}{name of column in df with exposure}
\item{severity}{name of column in df with severity}
\item{premium}{name of column in df with premium}
}
\description{
Claim frequency for discrete risk factors in an insurance portfolio. For each level of the risk factor the claim frequency is equal to the ratio between the number of claims and the exposure.
}
\examples{
univariate_frequency(MTPL2, x = area, nclaims = nclaims, exposure = exposure)
}
\author{
Martin Haringa
}
